<?php
declare(strict_types=1);

header('Content-Type: application/json');

// Autoload Composer dependencies
require __DIR__ . '/vendor/autoload.php';

// Your Google Service Account credentials
$serviceAccountJson = '{
  "type": "service_account",
  "project_id": "youtube-video-manager-470407",
  "private_key_id": "d14e73f24f9dd83d5a67b4ebe56dadacad89227b",
  "private_key": "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDN+Hs3QS/bIUIb\n3OYDyLf4iZQENQSOc6aHVqWQ4/CP5X4YEuupFyM+pXa1MT0pdyAmnLyqDessAmre\nRzrG7JGIR/0ruRYv1ZnTLPk15OvUNGa8lj1d+TBc+sup9OH5RW1zWU4meEk4n0lc\n4Z8zhIjuCfwfGVAPEefNxYg4o1GXu0lmjJgiR9AeY3KRZeDJF1qN5oLhndevlZPM\npUYc7sOAtL7Ubmc0AuvZtW3CDD0SyyN31UumHlvWyrANWhq9FqUQpKJbq1bnMF1z\nIg53zImgUIJX3ewiXdlCP4yoy0J94Qx9xqAT97PJ7J1dNAVcsF3b7zf0MKRxtRCW\nHJ7f5UgvAgMBAAECggEAKCPYv3fwv5/Hpm5yVSJ01/bX5cn/TVO0jIOSWJ5Tb3em\nD0MAsj9UGw1cCQvDg6U3ms7I5cs4nacK9K6lAcdwxUJiUHcNn9zc0Y7eMmaenwhn\nTTFqXDoH9tbZghG7SD0Di4tH869Vdbd1MKi3we5+UQWZIOZp98XhivSIC6GocQ0w\n5T3aFThyH+7etRbATRj5FpCGx9J3ptXIfnCHWyO7da5DL8m5gZhai069ynDSAVGR\nSkGf7I+cQ/n87VGizluEHH4OBLNY5Ax5t36F9Zi9BnZT0+zEQkxUwNeog4//ngxt\njek8LZlN1gZBT09sKbZ0g3bMI4GyUYkNqqsQRPDTAQKBgQD8eFqmCsb4pFVCsCI6\n0YQIn/cBx88gm9/4FBIU4lQ96oSV5izVKOb74sKLOg53wybZSpux/1QMe4tcjI8p\nN1ImP++R10KNI3dq1M/N6+4W+E2s362C2KYLCPetVl6xXaykUqc1YEhvrn7mayIn\nqZVi9mwhuzFO+6ns1adxxpxJzwKBgQDQ2bH/0gVN9+ksWmFJC/6hjYhKp5zbSkez\nh1OoS8eHPXvZ2ID/HrcurYXBbvwFPZBwwOtu1MSl358fJJ/WlicKMbQKU1/IiRE\nZd999VNfB4NPIW1rysndMWpSEY1LfhbUhMh2/fo9yWhGqy4ZKsE4HK/AoRvCb1JF\nblfu9neToQKBgQDpd3J8MWMl8vFVJgPBWJY8U5DbeKY1hW9rvUOrRFCaoQ/SfnPe\n+l//dgZpMVrHrRNzxOaNh4t1r5mEEAcjGiFBdcZYmzLTyYRYqkswJYiafSt3PbD6\nWtXRRo2jIUeXxQQtQLGXTl4tyLNY6KFBBDU8upvr5WsHmvncJQce04cbSQKBgAKX\nQMMIqvItqiHXuS87y9vbMp6id6qswDj068/BqOb/mMZwhOHBxxBn7IxakNtIl0l3\njtsf4MbxRCttLDASQdkmFFlOudxi4wpKLTyVx4P9Rt67bm0Q5fItg8Ei4JrYJJZc\nU1ROkEUl83o082xygFUe3ftIxFxkHyQnW0XmntMhAoGAYLtM0c/Erd6O0VLF8H04\nJaFXAAda18vxNOgvqIWdY+88WVG3Qcs3I2WkrJZLiAPklikzEMmbrKIOlONJYHNW\nBG2luyumZZon7WU8utJOrttDU2uGI8qpwg0+OwJWjc0P1aVsgIVcgoyCrHYT3PAA\nFM2aK6EMqIYB5hxnIg5dXro=\n-----END PRIVATE KEY-----\n",
  "client_email": "videogen@youtube-video-manager-470407.iam.gserviceaccount.com"
}';

// Google Sheet configuration
$spreadsheetId = '14RodHBDpVhdZL1n5RB_ZKXW5QNrSzBvwUhQA7hpmAFI';
$sheetName = 'videogen';

// Log any potential errors
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Function to send a standardized JSON response
function sendJsonResponse(array $data, int $httpStatus = 200): void
{
    http_response_code($httpStatus);
    echo json_encode($data);
    exit;
}

// Check for valid request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendJsonResponse(['success' => false, 'error' => 'Method Not Allowed'], 405);
}

// Decode JSON input
$inputData = json_decode(file_get_contents('php://input'), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    sendJsonResponse(['success' => false, 'error' => 'Invalid JSON input'], 400);
}

// Check for 'action' parameter
$action = $_GET['action'] ?? '';
if (empty($action)) {
    sendJsonResponse(['success' => false, 'error' => 'Action parameter is missing'], 400);
}

try {
    // Authenticate with Google Sheets
    $client = new \Google_Client();
    $client->setAuthConfig(json_decode($serviceAccountJson, true));
    $client->setScopes(['https://www.googleapis.com/auth/spreadsheets']);
    $service = new \Google_Service_Sheets($client);

    // Get spreadsheet and worksheet
    $spreadsheet = $service->spreadsheets;
    $worksheet = $spreadsheet->values;

    // Helper functions for spreadsheet interaction
    function findRowByLicenseKey(\Google_Service_Sheets $service, string $spreadsheetId, string $sheetName, string $licenseKey): ?int
    {
        $range = $sheetName . '!A:A';
        $response = $service->spreadsheets_values->get($spreadsheetId, $range);
        $values = $response->getValues();
        
        foreach ($values as $index => $row) {
            if (isset($row[0]) && $row[0] === $licenseKey) {
                return $index + 1;
            }
        }
        return null;
    }

    function getRowData(\Google_Service_Sheets $service, string $spreadsheetId, string $sheetName, int $rowIndex): ?array
    {
        $range = $sheetName . '!A' . $rowIndex . ':F' . $rowIndex;
        $response = $service->spreadsheets_values->get($spreadsheetId, $range);
        $values = $response->getValues();
        return $values[0] ?? null;
    }

    function updateCell(\Google_Service_Sheets $service, string $spreadsheetId, string $sheetName, string $cell, $value): void
    {
        $range = $sheetName . '!' . $cell;
        $body = new \Google_Service_Sheets_ValueRange(['values' => [[$value]]]);
        $params = ['valueInputOption' => 'RAW'];
        $service->spreadsheets_values->update($spreadsheetId, $range, $body, $params);
    }
    
    // --- API Endpoints ---
    switch ($action) {
        case 'verify-license':
            $licenseKey = $inputData['license_key'] ?? '';
            $deviceId = $inputData['device_id'] ?? '';
            
            $rowIndex = findRowByLicenseKey($service, $spreadsheetId, $sheetName, $licenseKey);
            if ($rowIndex === null) {
                sendJsonResponse(['success' => false, 'error' => 'Invalid license key.']);
            }
            
            $rowData = getRowData($service, $spreadsheetId, $sheetName, $rowIndex);
            $activatedDevices = json_decode($rowData[3] ?? '[]', true);
            
            if (!in_array($deviceId, $activatedDevices)) {
                sendJsonResponse(['success' => false, 'error' => 'Device is not activated.']);
            }
            
            $usage = $rowData[5] ?? 0;
            
            sendJsonResponse([
                'success' => true,
                'valid' => true,
                'license' => [
                    'plan_name' => $rowData[1],
                    'max_activations' => (int)($rowData[2] ?? 0),
                    'expiry_date' => $rowData[4] ?? null,
                    'features' => ['models' => ['all'], 'providers' => ['all']]
                ],
                'usage' => ['today_usage' => (int)$usage]
            ]);
            
        case 'activate-license':
            $licenseKey = $inputData['license_key'] ?? '';
            $deviceId = $inputData['device_id'] ?? '';
            
            $rowIndex = findRowByLicenseKey($service, $spreadsheetId, $sheetName, $licenseKey);
            if ($rowIndex === null) {
                sendJsonResponse(['success' => false, 'error' => 'Invalid license key.']);
            }
            
            $rowData = getRowData($service, $spreadsheetId, $sheetName, $rowIndex);
            $maxActivations = (int)($rowData[2] ?? 0);
            $activatedDevices = json_decode($rowData[3] ?? '[]', true);
            
            if (count($activatedDevices) >= $maxActivations) {
                sendJsonResponse(['success' => false, 'error' => 'Activation limit reached.']);
            }
            
            if (!in_array($deviceId, $activatedDevices)) {
                $activatedDevices[] = $deviceId;
                updateCell($service, $spreadsheetId, $sheetName, 'D' . $rowIndex, json_encode($activatedDevices));
            }
            
            sendJsonResponse(['success' => true, 'message' => 'License activated successfully.']);

        case 'deactivate-license':
            $licenseKey = $inputData['license_key'] ?? '';
            $deviceId = $inputData['device_id'] ?? '';

            $rowIndex = findRowByLicenseKey($service, $spreadsheetId, $sheetName, $licenseKey);
            if ($rowIndex === null) {
                sendJsonResponse(['success' => false, 'error' => 'Invalid license key.']);
            }

            $rowData = getRowData($service, $spreadsheetId, $sheetName, $rowIndex);
            $activatedDevices = json_decode($rowData[3] ?? '[]', true);

            $key = array_search($deviceId, $activatedDevices);
            if ($key !== false) {
                unset($activatedDevices[$key]);
                $activatedDevices = array_values($activatedDevices);
                updateCell($service, $spreadsheetId, $sheetName, 'D' . $rowIndex, json_encode($activatedDevices));
                sendJsonResponse(['success' => true, 'message' => 'License deactivated successfully.']);
            } else {
                sendJsonResponse(['success' => false, 'error' => 'Device not found.']);
            }
            
        case 'usage-tracking':
            $licenseKey = $inputData['license_key'] ?? '';
            $imagesGenerated = (int)($inputData['images_generated'] ?? 0);

            $rowIndex = findRowByLicenseKey($service, $spreadsheetId, $sheetName, $licenseKey);
            if ($rowIndex === null) {
                sendJsonResponse(['success' => false, 'error' => 'Invalid license key.']);
            }
            
            $rowData = getRowData($service, $spreadsheetId, $sheetName, $rowIndex);
            $currentUsage = (int)($rowData[5] ?? 0);
            $newUsage = $currentUsage + $imagesGenerated;
            
            updateCell($service, $spreadsheetId, $sheetName, 'F' . $rowIndex, $newUsage);
            
            sendJsonResponse(['success' => true, 'message' => 'Usage tracked.']);
            
        default:
            sendJsonResponse(['success' => false, 'error' => 'Unknown API action'], 404);
    }
} catch (Exception $e) {
    // Catch any unexpected exceptions and return a generic error
    sendJsonResponse(['success' => false, 'error' => 'An unexpected server error occurred: ' . $e->getMessage()], 500);
}